/********************************************************************/
/*  This file contains 3 sections:									*/
/*																	*/
/*	1) A Pre-Init Section - this section saves off all the			*/
/*		registers of the DSP.										*/
/*																	*/
/*	2) A Init Code Section - this section is the customer			*/
/*		initialization code which can be modified by the customer.	*/
/*		As an example, an SDRAM initialization code is supplied.	*/
/*																	*/
/*	3) A Post-Init Section - this section restores all the			*/
/*		register from the stack.									*/
/*																	*/
/*	Customers should not modify the Pre-Init and Post-Init Sections.*/
/*	The Init Code Section can be modified for application use.		*/
/********************************************************************/

#include <defBF533.h>

.section program;

/*******Pre-Init Section*********************************************/
/*******DO NOT MODIFY************************************************/
	[--SP] = ASTAT;			//Save Regs onto stack
	[--SP] = RETS;
	[--SP] = (r7:0);
	[--SP] = (p5:0);
	[--SP] = I0;
	[--SP] = I1;
	[--SP] = I2;
	[--SP] = I3;
	[--SP] = B0;
	[--SP] = B1;
	[--SP] = B2;
	[--SP] = B3;
	[--SP] = M0;
	[--SP] = M1;
	[--SP] = M2;
	[--SP] = M3;
	[--SP] = L0;
	[--SP] = L1;
	[--SP] = L2;
	[--SP] = L3;
/********************************************************************/

/*******Init Code Section********************************************/

/**Please insert Initialization code in this section************/

/*******SDRAM Setup************/
Setup_SDRAM:
	P0.L = EBIU_SDRRC & 0xFFFF;
	P0.H = (EBIU_SDRRC >> 16) & 0xFFFF;		//SDRAM Refresh Rate Control Register
//	R0 = 0x074A(Z);	//For EZKIT LITE BF537
	R0 = 0x03a0(Z);		//For CM-BF53x			
	W[P0] = R0;							
	SSYNC;	

	P0.L = EBIU_SDBCTL & 0xFFFF;			
	P0.H = (EBIU_SDBCTL >> 16) & 0xFFFF;	//SDRAM Memory Bank Control Register
//	R0 = 0x0001(Z);	//For EZKIT LITE BF537
	R0 = 0x0015(Z);		//For CM-BF53x			
	[P0] = R0;
	SSYNC;		

	P0.L = EBIU_SDGCTL & 0xFFFF;			
	P0.H = (EBIU_SDGCTL >> 16) & 0xFFFF;	//SDRAM Memory Global Control Register
//	R0.L = 0x998D;	//For EZKIT LITE BF537
//	R0.H = 0x0091;	//For EZKIT LITE BF537
	R0.L = 0x998D;		//For CM-BF53x			
	R0.H = 0x0091;		//For CM-BF53x		
	[P0] = R0;
	SSYNC;
	
// enabling the first two asynchronous banks
	P0.L = EBIU_AMBCTL0 & 0xFFFF;			
	P0.H = (EBIU_AMBCTL0 >> 16) & 0xFFFF;	//SDRAM Memory Global Control Register
	R0.L = 0x7bb0;		//For CM-BF53x			
	R0.H = 0x7bb0;		//For CM-BF53x		
	[P0] = R0;
	SSYNC;
	P0.L = EBIU_AMGCTL & 0xFFFF;			
	P0.H = (EBIU_AMGCTL >> 16) & 0xFFFF;	//SDRAM Memory Global Control Register
	R0.L = 0x00F4;		//For CM-BF53x			
	R0.H = 0x0000;		//For CM-BF53x		
	[P0] = R0;
	SSYNC;
	
/******************************/

/********************************************************************/

/*******Post-Init Section********************************************/
/*******DO NOT MODIFY************************************************/
	L3 = [SP++];
	L2 = [SP++];	
	L1 = [SP++];
	L0 = [SP++];
	M3 = [SP++];
	M2 = [SP++];
	M1 = [SP++];
	M0 = [SP++];
	B3 = [SP++];
	B2 = [SP++];
	B1 = [SP++];
	B0 = [SP++];
	I3 = [SP++];
	I2 = [SP++];
	I1 = [SP++];
	I0 = [SP++];
	(p5:0) = [SP++];  		//Restore Regs from Stack
	(r7:0) = [SP++];
	RETS = [SP++];
	ASTAT = [SP++];
/********************************************************************/

	RTS;
