/********************************************************************/
/*  This file contains 3 sections:									*/
/*																	*/
/*	1) A Pre-Init Section - this section saves off all the			*/
/*		registers of the DSP.										*/
/*																	*/
/*	2) A Init Code Section - this section is the customer			*/
/*		initialization code which can be modified by the customer.	*/
/*		As an example, an SDRAM initialization code is supplied.	*/
/*																	*/
/*	3) A Post-Init Section - this section restores all the			*/
/*		register from the stack.									*/
/*																	*/
/*	Customers should not modify the Pre-Init and Post-Init Sections.*/
/*	The Init Code Section can be modified for application use.		*/
/********************************************************************/

#include <defBF548.h>

.section L1_code;

.global _initcode;

/*******Pre-Init Section*********************************************/
/*******DO NOT MODIFY************************************************/
_initcode:
	[--SP] = ASTAT;			//Save Regs onto stack
	[--SP] = RETS;
	[--SP] = (r7:0);
	[--SP] = (p5:0);
	[--SP] = I0;
	[--SP] = I1;
	[--SP] = I2;
	[--SP] = I3;
	[--SP] = B0;
	[--SP] = B1;
	[--SP] = B2;
	[--SP] = B3;
	[--SP] = M0;
	[--SP] = M1;
	[--SP] = M2;
	[--SP] = M3;
	[--SP] = L0;
	[--SP] = L1;
	[--SP] = L2;
	[--SP] = L3;
/********************************************************************/

/*******Init Code Section********************************************/

/**Please insert Initialization code in this section************/

/*******SDRAM Setup************/
	P0.L = EBIU_RSTCTL & 0xFFFF;
	P0.H = (EBIU_RSTCTL >> 16) & 0xFFFF;
	R0 = W[P0];
	R1 = 3;
	R0 = R0 | R1;
	W[P0] = R0;							
	SSYNC;	

	P0.L = EBIU_AMGCTL & 0xFFFF;			
	P0.H = (EBIU_AMGCTL >> 16) & 0xFFFF;
	R0 = 0x0009(Z);
	W[P0] = R0;
	SSYNC;		

	P0.L = EBIU_DDRCTL0 & 0xFFFF;			
	P0.H = (EBIU_DDRCTL0 >> 16) & 0xFFFF;
	R0.L = 0x8287;
	R0.H = 0x218A;
	[P0] = R0;
	SSYNC;	
	P0.L = EBIU_DDRCTL1 & 0xFFFF;			
	P0.H = (EBIU_DDRCTL1 >> 16) & 0xFFFF;
	R0.L = 0x2222;
	R0.H = 0x2002;
	[P0] = R0;
	SSYNC;	
	P0.L = EBIU_DDRCTL2 & 0xFFFF;			
	P0.H = (EBIU_DDRCTL2 >> 16) & 0xFFFF;
	R0.L = 0x0021;	
	R0.H = 0x0000;	
	[P0] = R0;
	SSYNC;	
/******************************/

/********************************************************************/

/*******Post-Init Section********************************************/
/*******DO NOT MODIFY************************************************/
	L3 = [SP++];
	L2 = [SP++];	
	L1 = [SP++];
	L0 = [SP++];
	M3 = [SP++];
	M2 = [SP++];
	M1 = [SP++];
	M0 = [SP++];
	B3 = [SP++];
	B2 = [SP++];
	B1 = [SP++];
	B0 = [SP++];
	I3 = [SP++];
	I2 = [SP++];
	I1 = [SP++];
	I0 = [SP++];
	(p5:0) = [SP++];  		//Restore Regs from Stack
	(r7:0) = [SP++];
	RETS = [SP++];
	ASTAT = [SP++];
/********************************************************************/

	RTS;
_initcode.end: